﻿$(document).ready(function(){
	/**
	* Creates a table of concent of the 2nd and 3rd level headings on this page.
	*/
	var createListItem = function (i, header) {
		var anchorName = 'toc-' + i;
		var anchor = document.createElement('a');
		anchor.className = "waypoint";
		anchor.name = anchorName;
		header.parentNode.insertBefore(anchor, header);
		anchor.appendChild(header);

		var li = document.createElement('li');
		li.className = "waypoint-link";
		li.id = "waypoint-" + anchorName;
		li.innerHTML = '';
		li.insertAdjacentHTML('beforeend', '<a href="#' + anchorName + '">' + $(header).text() + '</a>');

		return li;
	}

	var container = document.createElement('ul');
	var currentContainer = container;
	var headers = $('h2, h3') || [];

	if (headers.length > 0) {
		headers.each(function (i, header) {
				var li = createListItem(i, header);

				if (header.tagName == 'H2') {
					container.appendChild(li);
					currentContainer = document.createElement('ul');
					currentContainer.className += " h3-child-list";
					li.appendChild(currentContainer)
				} else {
					currentContainer.appendChild(li);
				}
			});

		var btt = $("<li><a id='back-top' href='#'></a></li>");
		btt.click(function(){
			document.body.scrollTop = 0; // For Safari
			document.documentElement.scrollTop = 0; // For Chrome, Firefox, IE and Opera
		});
		$(container).append(btt);
		container.classList.add('box');
		$('body').addClass('bodybody');


		var parent = document.getElementById('contentNav');
		parent.insertBefore(container, parent.firstChild);
		
		var onPage = $("meta[name='on-this-page']").attr("content");
		var title = $('<div>')
			.addClass("nav-title");
			title.html(onPage);

			
		$(parent).prepend(title);

		var backLink = $("meta[name='back-top-link']").attr("content");
		$("#back-top").text(backLink);

		/*
		* Automatically fold/unfold and focus each TOC module as the user scrolls
		* through the page.
		*/
		var anchorOffsets = [];
		$('.waypoint').each(function (i, el) {
			var anchor = $(el);
			anchorOffsets.push({
				name: anchor.attr('name'),
				top: anchor.offset().top - 60
				});
		});

		window.scrollThrottle = new Date().getTime();
		var scrollHandler = function () {
				window.requestAnimationFrame(function () {
						window.clearTimeout(window.scrollTimeout);

						var now = new Date().getTime();
						if (now > window.scrollThrottle + 100) {
							window.scrollThrottle = now;
							var top = $(window).scrollTop();
							var lastAnchor = anchorOffsets[0];
							for (var i = 0; i < anchorOffsets.length; ++i) {
								var anchor = anchorOffsets[i];
								if (anchor.top > top) {
									break;
								}
								lastAnchor = anchor;
							}
							$('.waypoint-link.active').removeClass('active');
							$('.waypoint-link.is-opened').removeClass('is-opened');
							$('a[href = "#' + lastAnchor.name + '"]').parents('.waypoint-link').addClass('is-opened');
							$('a[href = "#' + lastAnchor.name + '"]').parent().addClass('active');
						} else {
							scrollTimeout = window.setTimeout(scrollHandler, 50);
						}
					});
			}

			$(window).on('scroll', function () {
				scrollHandler();
			});

		$(window).on('resize', function () {
				scrollHandler();
			});
	}
});